/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.enrich.action;

import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodeRole;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Randomness;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.core.Set;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.tasks.TaskAwareRequest;
import org.elasticsearch.tasks.TaskCancelledException;
import org.elasticsearch.tasks.TaskId;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyAction;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyStatus;
import org.elasticsearch.xpack.enrich.EnrichPolicyExecutor;
import org.elasticsearch.xpack.enrich.ExecuteEnrichPolicyTask;

public class InternalExecutePolicyAction
extends ActionType<ExecuteEnrichPolicyAction.Response> {
    private static final Logger LOGGER = LogManager.getLogger(InternalExecutePolicyAction.class);
    public static final InternalExecutePolicyAction INSTANCE = new InternalExecutePolicyAction();
    public static final String NAME = "cluster:admin/xpack/enrich/internal_execute";

    private InternalExecutePolicyAction() {
        super(NAME, ExecuteEnrichPolicyAction.Response::new);
    }

    public static class Transport
    extends HandledTransportAction<Request, ExecuteEnrichPolicyAction.Response> {
        private final ClusterService clusterService;
        private final TransportService transportService;
        private final EnrichPolicyExecutor policyExecutor;
        private final AtomicInteger nodeGenerator = new AtomicInteger(Randomness.get().nextInt());

        @Inject
        public Transport(TransportService transportService, ActionFilters actionFilters, ClusterService clusterService, EnrichPolicyExecutor policyExecutor) {
            super(InternalExecutePolicyAction.NAME, transportService, actionFilters, Request::new);
            this.clusterService = clusterService;
            this.transportService = transportService;
            this.policyExecutor = policyExecutor;
        }

        protected void doExecute(Task transportTask, final Request request, ActionListener<ExecuteEnrichPolicyAction.Response> actionListener) {
            ClusterState clusterState = this.clusterService.state();
            DiscoveryNode targetNode = this.selectNodeForPolicyExecution(clusterState.nodes());
            if (!clusterState.nodes().getLocalNode().equals((Object)targetNode)) {
                ActionListenerResponseHandler handler = new ActionListenerResponseHandler(actionListener, ExecuteEnrichPolicyAction.Response::new);
                this.transportService.sendRequest(targetNode, InternalExecutePolicyAction.NAME, (TransportRequest)request, (TransportResponseHandler)handler);
                return;
            }
            ExecuteEnrichPolicyTask task = (ExecuteEnrichPolicyTask)this.taskManager.register("enrich", "policy_execution", new TaskAwareRequest(){

                public void setParentTask(TaskId taskId) {
                    request.setParentTask(taskId);
                }

                public TaskId getParentTask() {
                    return request.getParentTask();
                }

                public Task createTask(long id, String type, String action, TaskId parentTaskId, Map<String, String> headers) {
                    String description = "executing enrich policy [" + request.getName() + "] creating new enrich index [" + request.getEnrichIndexName() + "]";
                    return new ExecuteEnrichPolicyTask(id, type, action, description, parentTaskId, headers);
                }
            });
            try {
                ActionListener listener = request.isWaitForCompletion() ? ActionListener.wrap(result -> actionListener.onResponse((Object)new ExecuteEnrichPolicyAction.Response(result)), arg_0 -> actionListener.onFailure(arg_0)) : ActionListener.wrap(result -> LOGGER.debug("successfully executed policy [{}]", (Object)request.getName()), e -> {
                    if (e instanceof TaskCancelledException) {
                        LOGGER.info(e.getMessage());
                    } else {
                        LOGGER.error("failed to execute policy [" + request.getName() + "]", (Throwable)e);
                    }
                });
                this.policyExecutor.runPolicyLocally(task, request.getName(), request.getEnrichIndexName(), (ActionListener<ExecuteEnrichPolicyStatus>)ActionListener.wrap(result -> {
                    this.taskManager.unregister((Task)task);
                    listener.onResponse(result);
                }, e -> {
                    this.taskManager.unregister((Task)task);
                    listener.onFailure(e);
                }));
                if (!request.isWaitForCompletion()) {
                    TaskId taskId = new TaskId(clusterState.nodes().getLocalNodeId(), task.getId());
                    actionListener.onResponse((Object)new ExecuteEnrichPolicyAction.Response(taskId));
                }
            }
            catch (Exception e2) {
                this.taskManager.unregister((Task)task);
                throw e2;
            }
        }

        DiscoveryNode selectNodeForPolicyExecution(DiscoveryNodes discoNodes) {
            if (discoNodes.getIngestNodes().isEmpty()) {
                throw new IllegalStateException("no ingest nodes in this cluster");
            }
            if (discoNodes.getSize() == 1) {
                return discoNodes.getLocalNode();
            }
            if (!discoNodes.isLocalNodeElectedMaster()) {
                return discoNodes.getLocalNode();
            }
            DiscoveryNode[] nodes = (DiscoveryNode[])discoNodes.getAllNodes().stream().filter(discoNode -> !discoNode.getId().equals(discoNodes.getMasterNodeId())).filter(discoNode -> !discoNode.getRoles().equals(Set.of((Object)DiscoveryNodeRole.MASTER_ROLE))).filter(discoNode -> discoNode.getVersion().onOrAfter(Version.V_7_15_0)).toArray(DiscoveryNode[]::new);
            if (nodes.length == 0) {
                throw new IllegalStateException("no suitable node was found to perform enrich policy execution");
            }
            return nodes[Math.floorMod(this.nodeGenerator.incrementAndGet(), nodes.length)];
        }
    }

    public static class Request
    extends ExecuteEnrichPolicyAction.Request {
        private final String enrichIndexName;

        public Request(String name, String enrichIndexName) {
            super(name);
            this.enrichIndexName = enrichIndexName;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.enrichIndexName = in.readString();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.enrichIndexName);
        }

        public String getEnrichIndexName() {
            return this.enrichIndexName;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.enrichIndexName, request.enrichIndexName);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.enrichIndexName);
        }
    }
}

