/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression;

import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.AttributeMap;

public class AttributeSet
implements Set<Attribute> {
    private static final AttributeMap<Object> EMPTY_DELEGATE = AttributeMap.emptyAttributeMap();
    public static final AttributeSet EMPTY = new AttributeSet(EMPTY_DELEGATE);
    private static final Object PRESENT = new Object();
    private final AttributeMap<Object> delegate;

    public AttributeSet() {
        this.delegate = new AttributeMap();
    }

    public AttributeSet(Attribute attr) {
        this.delegate = new AttributeMap<Object>(attr, PRESENT);
    }

    public AttributeSet(Collection<? extends Attribute> attr) {
        if (attr.isEmpty()) {
            this.delegate = EMPTY_DELEGATE;
        } else {
            this.delegate = new AttributeMap();
            for (Attribute attribute : attr) {
                this.delegate.add(attribute, PRESENT);
            }
        }
    }

    private AttributeSet(AttributeMap<Object> delegate) {
        this.delegate = delegate;
    }

    void addAll(AttributeSet other) {
        this.delegate.addAll(other.delegate);
    }

    public AttributeSet combine(AttributeSet other) {
        return new AttributeSet(this.delegate.combine(other.delegate));
    }

    public AttributeSet subtract(AttributeSet other) {
        return new AttributeSet(this.delegate.subtract(other.delegate));
    }

    public AttributeSet intersect(AttributeSet other) {
        return new AttributeSet(this.delegate.intersect(other.delegate));
    }

    public boolean subsetOf(AttributeSet other) {
        return this.delegate.subsetOf(other.delegate);
    }

    public Set<String> names() {
        return this.delegate.attributeNames();
    }

    @Override
    public void forEach(Consumer<? super Attribute> action) {
        this.delegate.forEach((? super Attribute k, ? super E v) -> action.accept((Attribute)k));
    }

    @Override
    public int size() {
        return this.delegate.size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.delegate.containsKey(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.delegate.containsKey(o)) continue;
            return false;
        }
        return true;
    }

    @Override
    public Iterator<Attribute> iterator() {
        return this.delegate.keySet().iterator();
    }

    @Override
    public Object[] toArray() {
        return this.delegate.keySet().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.delegate.keySet().toArray(a);
    }

    @Override
    public boolean add(Attribute e) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Attribute> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Spliterator<Attribute> spliterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeIf(Predicate<? super Attribute> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<Attribute> stream() {
        return this.delegate.keySet().stream();
    }

    @Override
    public Stream<Attribute> parallelStream() {
        return this.delegate.keySet().parallelStream();
    }

    @Override
    public boolean equals(Object o) {
        return this.delegate.equals(o);
    }

    @Override
    public int hashCode() {
        return this.delegate.hashCode();
    }

    public String toString() {
        return this.delegate.keySet().toString();
    }
}

