/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.List;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.elasticsearch.cli.Terminal;
import org.elasticsearch.cli.UserException;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.Streams;
import org.elasticsearch.common.settings.BaseKeyStoreCommand;
import org.elasticsearch.common.settings.KeyStoreWrapper;
import org.elasticsearch.env.Environment;

public class ShowKeyStoreCommand
extends BaseKeyStoreCommand {
    private final OptionSpec<String> arguments;

    public ShowKeyStoreCommand() {
        super("Show a value from the keystore", true);
        this.arguments = this.parser.nonOptions("setting name");
    }

    protected void executeCommand(Terminal terminal, OptionSet options, Environment env) throws Exception {
        block13: {
            List names = this.arguments.values(options);
            if (names.size() != 1) {
                throw new UserException(64, "Must provide a single setting name to show");
            }
            String settingName = (String)names.get(0);
            KeyStoreWrapper keyStore = this.getKeyStore();
            if (!keyStore.getSettingNames().contains(settingName)) {
                throw new UserException(78, "Setting [" + settingName + "] does not exist in the keystore.");
            }
            try (InputStream input = keyStore.getFile(settingName);){
                BytesReference bytes = Streams.readFully((InputStream)input);
                try {
                    boolean isFileOutput;
                    byte[] array = BytesReference.toBytes((BytesReference)bytes);
                    CharBuffer text = StandardCharsets.UTF_8.newDecoder().onMalformedInput(CodingErrorAction.REPORT).onUnmappableCharacter(CodingErrorAction.REPORT).decode(ByteBuffer.wrap(array));
                    boolean bl = isFileOutput = terminal.getOutputStream() != null;
                    if (isFileOutput) {
                        terminal.print(Terminal.Verbosity.SILENT, text.toString());
                    } else {
                        terminal.println(Terminal.Verbosity.SILENT, (CharSequence)text);
                    }
                }
                catch (CharacterCodingException e) {
                    OutputStream output = terminal.getOutputStream();
                    if (output != null) {
                        bytes.writeTo(output);
                        break block13;
                    }
                    terminal.errorPrintln(Terminal.Verbosity.VERBOSE, e.toString());
                    terminal.errorPrintln("The value for the setting [" + settingName + "] is not a string and cannot be printed to the console");
                    throw new UserException(74, "Please redirect binary output to a file instead");
                }
            }
        }
    }
}

