/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.watcher.execution;

import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.watcher.execution.WatchExecutionContext;

public class QueuedWatch
implements Writeable,
ToXContentObject {
    private String watchId;
    private String watchRecordId;
    private ZonedDateTime triggeredTime;
    private ZonedDateTime executionTime;

    public QueuedWatch(WatchExecutionContext ctx) {
        this.watchId = ctx.id().watchId();
        this.watchRecordId = ctx.id().value();
        this.triggeredTime = ctx.triggerEvent().triggeredTime();
        this.executionTime = ctx.executionTime();
    }

    public QueuedWatch(StreamInput in) throws IOException {
        this.watchId = in.readString();
        this.watchRecordId = in.readString();
        this.triggeredTime = Instant.ofEpochMilli(in.readVLong()).atZone(ZoneOffset.UTC);
        this.executionTime = Instant.ofEpochMilli(in.readVLong()).atZone(ZoneOffset.UTC);
    }

    public String watchId() {
        return this.watchId;
    }

    public ZonedDateTime triggeredTime() {
        return this.triggeredTime;
    }

    public void triggeredTime(ZonedDateTime triggeredTime) {
        this.triggeredTime = triggeredTime;
    }

    public ZonedDateTime executionTime() {
        return this.executionTime;
    }

    public void executionTime(ZonedDateTime executionTime) {
        this.executionTime = executionTime;
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.watchId);
        out.writeString(this.watchRecordId);
        out.writeVLong(this.triggeredTime.toInstant().toEpochMilli());
        out.writeVLong(this.executionTime.toInstant().toEpochMilli());
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field("watch_id", this.watchId);
        builder.field("watch_record_id", this.watchRecordId);
        builder.timeField("triggered_time", (Object)this.triggeredTime);
        builder.timeField("execution_time", (Object)this.executionTime);
        builder.endObject();
        return builder;
    }
}

