/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.user.User;

public final class AuthenticationResult {
    private static final AuthenticationResult NOT_HANDLED = new AuthenticationResult(Status.CONTINUE, null, null, null, null);
    public static String THREAD_CONTEXT_KEY = "_xpack_security_auth_result";
    private final Status status;
    private final User user;
    private final String message;
    private final Exception exception;
    private final Map<String, Object> metadata;

    private AuthenticationResult(Status status, @Nullable User user, @Nullable String message, @Nullable Exception exception, @Nullable Map<String, Object> metadata) {
        this.status = status;
        this.user = user;
        this.message = message;
        this.exception = exception;
        this.metadata = metadata == null ? Collections.emptyMap() : Collections.unmodifiableMap(metadata);
    }

    public Status getStatus() {
        return this.status;
    }

    public User getUser() {
        return this.user;
    }

    public String getMessage() {
        return this.message;
    }

    public Exception getException() {
        return this.exception;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public static AuthenticationResult success(User user) {
        return AuthenticationResult.success(user, null);
    }

    public static AuthenticationResult success(User user, @Nullable Map<String, Object> metadata) {
        Objects.requireNonNull(user);
        return new AuthenticationResult(Status.SUCCESS, user, null, null, metadata);
    }

    public static AuthenticationResult notHandled() {
        return NOT_HANDLED;
    }

    public static AuthenticationResult unsuccessful(String message, @Nullable Exception cause) {
        Objects.requireNonNull(message);
        return new AuthenticationResult(Status.CONTINUE, null, message, cause, null);
    }

    public static AuthenticationResult terminate(String message, @Nullable Exception cause) {
        return new AuthenticationResult(Status.TERMINATE, null, message, cause, null);
    }

    public boolean isAuthenticated() {
        return this.status == Status.SUCCESS;
    }

    public String toString() {
        return "AuthenticationResult{status=" + (Object)((Object)this.status) + ", user=" + this.user + ", message=" + this.message + ", exception=" + this.exception + '}';
    }

    public static enum Status {
        SUCCESS,
        CONTINUE,
        TERMINATE;

    }
}

