/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup.job;

import java.io.IOException;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.Rounding;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramAggregationBuilder;
import org.elasticsearch.search.aggregations.bucket.histogram.DateHistogramInterval;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.rollup.RollupField;

public class DateHistogramGroupConfig
implements Writeable,
ToXContentObject {
    static final String NAME = "date_histogram";
    public static final String INTERVAL = "interval";
    public static final String FIXED_INTERVAL = "fixed_interval";
    public static final String CALENDAR_INTERVAL = "calendar_interval";
    public static final String TIME_ZONE = "time_zone";
    public static final String DELAY = "delay";
    private static final String DEFAULT_TIMEZONE = "UTC";
    public static final ZoneId DEFAULT_ZONEID_TIMEZONE = ZoneOffset.UTC;
    private static final String FIELD = "field";
    private static final String TYPE_NAME = "interval";
    private static final ConstructingObjectParser<DateHistogramGroupConfig, Void> PARSER = new ConstructingObjectParser("date_histogram", a -> {
        DateHistogramInterval oldInterval = (DateHistogramInterval)a[1];
        DateHistogramInterval calendarInterval = (DateHistogramInterval)a[2];
        DateHistogramInterval fixedInterval = (DateHistogramInterval)a[3];
        if (oldInterval != null) {
            if (calendarInterval != null || fixedInterval != null) {
                throw new IllegalArgumentException("Cannot use [interval] with [fixed_interval] or [calendar_interval] configuration options.");
            }
            return DateHistogramGroupConfig.fromUnknownTimeUnit((String)a[0], oldInterval, (DateHistogramInterval)a[4], (String)a[5]);
        }
        if (calendarInterval != null && fixedInterval == null) {
            return new CalendarInterval((String)a[0], calendarInterval, (DateHistogramInterval)a[4], (String)a[5]);
        }
        if (calendarInterval == null && fixedInterval != null) {
            return new FixedInterval((String)a[0], fixedInterval, (DateHistogramInterval)a[4], (String)a[5]);
        }
        if (calendarInterval != null && fixedInterval != null) {
            throw new IllegalArgumentException("Cannot set both [fixed_interval] and [calendar_interval] at the same time");
        }
        throw new IllegalArgumentException("An interval is required.  Use [fixed_interval] or [calendar_interval].");
    });
    private final String field;
    private final DateHistogramInterval interval;
    private final DateHistogramInterval delay;
    private final String timeZone;

    private static DateHistogramGroupConfig fromUnknownTimeUnit(String field, DateHistogramInterval interval, DateHistogramInterval delay, String timeZone) {
        if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(interval.toString()) != null) {
            return new CalendarInterval(field, interval, delay, timeZone);
        }
        return new FixedInterval(field, interval, delay, timeZone);
    }

    static DateHistogramGroupConfig fromUnknownTimeUnit(StreamInput in) throws IOException {
        DateHistogramInterval interval = new DateHistogramInterval(in);
        String field = in.readString();
        DateHistogramInterval delay = (DateHistogramInterval)in.readOptionalWriteable(DateHistogramInterval::new);
        String timeZone = in.readString();
        return DateHistogramGroupConfig.fromUnknownTimeUnit(field, interval, delay, timeZone);
    }

    @Deprecated
    public DateHistogramGroupConfig(String field, DateHistogramInterval interval) {
        this(field, interval, null, null);
    }

    @Deprecated
    public DateHistogramGroupConfig(String field, DateHistogramInterval interval, @Nullable DateHistogramInterval delay, @Nullable String timeZone) {
        if (field == null || field.isEmpty()) {
            throw new IllegalArgumentException("Field must be a non-null, non-empty string");
        }
        if (interval == null) {
            throw new IllegalArgumentException("Interval must be non-null");
        }
        this.interval = interval;
        this.field = field;
        this.delay = delay;
        this.timeZone = timeZone != null && !timeZone.isEmpty() ? timeZone : DEFAULT_TIMEZONE;
        DateHistogramGroupConfig.createRounding(this.interval.toString(), this.timeZone);
        if (delay != null) {
            TimeValue.parseTimeValue((String)this.delay.toString(), (String)DELAY);
        }
    }

    @Deprecated
    DateHistogramGroupConfig(StreamInput in) throws IOException {
        this.interval = new DateHistogramInterval(in);
        this.field = in.readString();
        this.delay = (DateHistogramInterval)in.readOptionalWriteable(DateHistogramInterval::new);
        this.timeZone = in.readString();
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.interval.writeTo(out);
        out.writeString(this.field);
        out.writeOptionalWriteable((Writeable)this.delay);
        out.writeString(this.timeZone);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(this.getIntervalTypeName(), this.interval.toString());
        builder.field(FIELD, this.field);
        if (this.delay != null) {
            builder.field(DELAY, this.delay.toString());
        }
        builder.field(TIME_ZONE, this.timeZone);
        return builder.endObject();
    }

    public String getField() {
        return this.field;
    }

    public DateHistogramInterval getInterval() {
        return this.interval;
    }

    public DateHistogramInterval getDelay() {
        return this.delay;
    }

    public String getTimeZone() {
        return this.timeZone;
    }

    public Rounding.Prepared createRounding() {
        return DateHistogramGroupConfig.createRounding(this.interval.toString(), this.timeZone);
    }

    public String getIntervalTypeName() {
        return "interval";
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        Map<String, FieldCapabilities> fieldCaps = fieldCapsResponse.get(this.field);
        if (fieldCaps != null && !fieldCaps.isEmpty()) {
            boolean matchesDateType = false;
            for (String dateType : RollupField.DATE_FIELD_MAPPER_TYPES) {
                if (!fieldCaps.containsKey(dateType) || fieldCaps.size() != 1) continue;
                matchesDateType |= true;
                if (fieldCaps.get(dateType).isAggregatable()) {
                    return;
                }
                validationException.addValidationError("The field [" + this.field + "] must be aggregatable across all indices, but is not.");
            }
            if (!matchesDateType) {
                validationException.addValidationError("The field referenced by a date_histo group must be one of type [" + Strings.collectionToCommaDelimitedString(RollupField.DATE_FIELD_MAPPER_TYPES) + "] across all indices in the index pattern.  Found: " + fieldCaps.keySet().toString() + " for field [" + this.field + "]");
            }
        } else {
            validationException.addValidationError("Could not find one of [" + Strings.collectionToCommaDelimitedString(RollupField.DATE_FIELD_MAPPER_TYPES) + "] fields with name [" + this.field + "] in any of the indices matching the index pattern.");
        }
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !(other instanceof DateHistogramGroupConfig)) {
            return false;
        }
        DateHistogramGroupConfig that = (DateHistogramGroupConfig)other;
        return Objects.equals(this.interval, that.interval) && Objects.equals(this.field, that.field) && Objects.equals(this.delay, that.delay) && ZoneId.of(this.timeZone, ZoneId.SHORT_IDS).getRules().equals(ZoneId.of(that.timeZone, ZoneId.SHORT_IDS).getRules());
    }

    public int hashCode() {
        return Objects.hash(this.interval, this.field, this.delay, ZoneId.of(this.timeZone));
    }

    public String toString() {
        return Strings.toString((ToXContent)this, (boolean)true, (boolean)true);
    }

    public static DateHistogramGroupConfig fromXContent(XContentParser parser) throws IOException {
        return (DateHistogramGroupConfig)PARSER.parse(parser, null);
    }

    private static Rounding.Prepared createRounding(String expr, String timeZone) {
        Rounding.DateTimeUnit timeUnit = (Rounding.DateTimeUnit)DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(expr);
        Rounding.Builder rounding = timeUnit != null ? new Rounding.Builder(timeUnit) : new Rounding.Builder(TimeValue.parseTimeValue((String)expr, (String)"createRounding"));
        rounding.timeZone(ZoneId.of(timeZone, ZoneId.SHORT_IDS));
        return rounding.build().prepareForUnknown();
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), new ParseField(FIELD, new String[0]));
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField("interval", new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(CALENDAR_INTERVAL, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(FIXED_INTERVAL, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), p -> new DateHistogramInterval(p.text()), new ParseField(DELAY, new String[0]), ObjectParser.ValueType.STRING);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), new ParseField(TIME_ZONE, new String[0]));
    }

    public static class CalendarInterval
    extends DateHistogramGroupConfig {
        private static final String TYPE_NAME = "calendar_interval";

        public CalendarInterval(String field, DateHistogramInterval interval) {
            this(field, interval, null, null);
        }

        public CalendarInterval(String field, DateHistogramInterval interval, DateHistogramInterval delay, String timeZone) {
            super(field, interval, delay, timeZone);
            if (DateHistogramAggregationBuilder.DATE_FIELD_UNITS.get(interval.toString()) == null) {
                throw new IllegalArgumentException("The supplied interval [" + interval + "] could not be parsed as a calendar interval.");
            }
        }

        CalendarInterval(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public String getIntervalTypeName() {
            return "calendar_interval";
        }
    }

    public static class FixedInterval
    extends DateHistogramGroupConfig {
        private static final String TYPE_NAME = "fixed_interval";

        public FixedInterval(String field, DateHistogramInterval interval) {
            this(field, interval, null, null);
        }

        public FixedInterval(String field, DateHistogramInterval interval, DateHistogramInterval delay, String timeZone) {
            super(field, interval, delay, timeZone);
            TimeValue.parseTimeValue((String)interval.toString(), (String)"date_histogram.FixedInterval");
        }

        FixedInterval(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public String getIntervalTypeName() {
            return "fixed_interval";
        }
    }
}

