/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.utils;

import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Optional;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.cluster.health.ClusterHealthRequest;
import org.elasticsearch.action.admin.indices.alias.Alias;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequest;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.template.put.PutComposableIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.ClusterAdminClient;
import org.elasticsearch.client.IndicesAdminClient;
import org.elasticsearch.client.Requests;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.ComposableIndexTemplate;
import org.elasticsearch.cluster.metadata.IndexAbstraction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.index.Index;
import org.elasticsearch.indices.SystemIndexDescriptor;
import org.elasticsearch.xcontent.DeprecationHandler;
import org.elasticsearch.xcontent.NamedXContentRegistry;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.ClientHelper;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.template.IndexTemplateConfig;

public final class MlIndexAndAlias {
    private static final Logger logger = LogManager.getLogger(MlIndexAndAlias.class);
    static final Version HIDDEN_INTRODUCED_VERSION = Version.V_7_7_0;
    static final Comparator<String> INDEX_NAME_COMPARATOR = new Comparator<String>(){
        private final Pattern HAS_SIX_DIGIT_SUFFIX = Pattern.compile("\\d{6}");

        @Override
        public int compare(String index1, String index2) {
            String[] index1Parts = index1.split("-");
            String index1Suffix = index1Parts[index1Parts.length - 1];
            boolean index1HasSixDigitsSuffix = this.HAS_SIX_DIGIT_SUFFIX.matcher(index1Suffix).matches();
            String[] index2Parts = index2.split("-");
            String index2Suffix = index2Parts[index2Parts.length - 1];
            boolean index2HasSixDigitsSuffix = this.HAS_SIX_DIGIT_SUFFIX.matcher(index2Suffix).matches();
            if (index1HasSixDigitsSuffix && index2HasSixDigitsSuffix) {
                return index1Suffix.compareTo(index2Suffix);
            }
            if (index1HasSixDigitsSuffix != index2HasSixDigitsSuffix) {
                return Boolean.compare(index1HasSixDigitsSuffix, index2HasSixDigitsSuffix);
            }
            return index1.compareTo(index2);
        }
    };

    private MlIndexAndAlias() {
    }

    public static void createIndexAndAliasIfNecessary(Client client, ClusterState clusterState, IndexNameExpressionResolver resolver, String indexPatternPrefix, String alias, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        Optional indexPointedByCurrentWriteAlias;
        ActionListener loggingListener = ActionListener.wrap(arg_0 -> finalListener.onResponse(arg_0), e -> {
            logger.error((Message)new ParameterizedMessage("Failed to create alias and index with pattern [{}] and alias [{}]", (Object)indexPatternPrefix, (Object)alias), (Throwable)e);
            finalListener.onFailure(e);
        });
        ActionListener indexCreatedListener = ActionListener.wrap(created -> {
            if (created.booleanValue()) {
                MlIndexAndAlias.waitForShardsReady(client, alias, masterNodeTimeout, (ActionListener<Boolean>)loggingListener);
            } else {
                loggingListener.onResponse((Object)false);
            }
        }, arg_0 -> ((ActionListener)loggingListener).onFailure(arg_0));
        boolean isHiddenAttributeAvailable = clusterState.nodes().getMinNodeVersion().onOrAfter(HIDDEN_INTRODUCED_VERSION);
        String legacyIndexWithoutSuffix = indexPatternPrefix;
        String indexPattern = indexPatternPrefix + "*";
        String firstConcreteIndex = indexPatternPrefix + "-000001";
        String[] concreteIndexNames = resolver.concreteIndexNames(clusterState, IndicesOptions.lenientExpandHidden(), new String[]{indexPattern});
        Optional<Object> optional = indexPointedByCurrentWriteAlias = clusterState.getMetadata().hasAlias(alias) ? ((IndexAbstraction)clusterState.getMetadata().getIndicesLookup().get(alias)).getIndices().stream().map(Index::getName).findFirst() : Optional.empty();
        if (concreteIndexNames.length == 0) {
            if (!indexPointedByCurrentWriteAlias.isPresent()) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, true, isHiddenAttributeAvailable, (ActionListener<Boolean>)indexCreatedListener);
                return;
            }
            logger.error("There are no indices matching '{}' pattern but '{}' alias points at [{}]. This should never happen.", (Object)indexPattern, (Object)alias, indexPointedByCurrentWriteAlias.get());
        } else if (concreteIndexNames.length == 1 && concreteIndexNames[0].equals(legacyIndexWithoutSuffix)) {
            if (!indexPointedByCurrentWriteAlias.isPresent()) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, true, isHiddenAttributeAvailable, (ActionListener<Boolean>)indexCreatedListener);
                return;
            }
            if (((String)indexPointedByCurrentWriteAlias.get()).equals(legacyIndexWithoutSuffix)) {
                MlIndexAndAlias.createFirstConcreteIndex(client, firstConcreteIndex, alias, false, isHiddenAttributeAvailable, (ActionListener<Boolean>)ActionListener.wrap(unused -> MlIndexAndAlias.updateWriteAlias(client, alias, legacyIndexWithoutSuffix, firstConcreteIndex, isHiddenAttributeAvailable, (ActionListener<Boolean>)indexCreatedListener), arg_0 -> ((ActionListener)loggingListener).onFailure(arg_0)));
                return;
            }
            logger.error("There is exactly one index (i.e. '{}') matching '{}' pattern but '{}' alias points at [{}]. This should never happen.", (Object)legacyIndexWithoutSuffix, (Object)indexPattern, (Object)alias, indexPointedByCurrentWriteAlias.get());
        } else if (!indexPointedByCurrentWriteAlias.isPresent()) {
            assert (concreteIndexNames.length > 0);
            String latestConcreteIndexName = Arrays.stream(concreteIndexNames).max(INDEX_NAME_COMPARATOR).get();
            MlIndexAndAlias.updateWriteAlias(client, alias, null, latestConcreteIndexName, isHiddenAttributeAvailable, (ActionListener<Boolean>)loggingListener);
            return;
        }
        loggingListener.onResponse((Object)false);
    }

    public static void createSystemIndexIfNecessary(Client client, ClusterState clusterState, SystemIndexDescriptor descriptor, TimeValue masterNodeTimeout, ActionListener<Boolean> finalListener) {
        String primaryIndex = descriptor.getPrimaryIndex();
        if (MlIndexAndAlias.hasIndex(clusterState, primaryIndex)) {
            finalListener.onResponse((Object)true);
            return;
        }
        ActionListener indexCreatedListener = ActionListener.wrap(created -> {
            if (created.booleanValue()) {
                MlIndexAndAlias.waitForShardsReady(client, primaryIndex, masterNodeTimeout, finalListener);
            } else {
                finalListener.onResponse((Object)false);
            }
        }, e -> {
            if (ExceptionsHelper.unwrapCause(e) instanceof ResourceAlreadyExistsException) {
                finalListener.onResponse((Object)true);
            } else {
                finalListener.onFailure(e);
            }
        });
        CreateIndexRequest createIndexRequest = new CreateIndexRequest(primaryIndex);
        createIndexRequest.settings(descriptor.getSettings());
        createIndexRequest.mapping("_doc", descriptor.getMappings(), XContentType.JSON);
        createIndexRequest.origin("ml");
        createIndexRequest.masterNodeTimeout(masterNodeTimeout);
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", createIndexRequest, ActionListener.wrap(r -> indexCreatedListener.onResponse((Object)r.isAcknowledged()), arg_0 -> ((ActionListener)indexCreatedListener).onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).create(arg_0, arg_1));
    }

    private static void waitForShardsReady(Client client, String index, TimeValue masterNodeTimeout, ActionListener<Boolean> listener) {
        ClusterHealthRequest healthRequest = (ClusterHealthRequest)Requests.clusterHealthRequest((String[])new String[]{index}).waitForYellowStatus().waitForNoRelocatingShards(true).waitForNoInitializingShards(true).masterNodeTimeout(masterNodeTimeout);
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", healthRequest, ActionListener.wrap(response -> listener.onResponse((Object)(!response.isTimedOut() ? 1 : 0)), arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((ClusterAdminClient)client.admin().cluster()).health(arg_0, arg_1));
    }

    private static void createFirstConcreteIndex(Client client, String index, String alias, boolean addAlias, boolean isHiddenAttributeAvailable, ActionListener<Boolean> listener) {
        logger.info("About to create first concrete index [{}] with alias [{}]", (Object)index, (Object)alias);
        CreateIndexRequestBuilder requestBuilder = client.admin().indices().prepareCreate(index);
        if (addAlias) {
            Alias newAlias = new Alias(alias);
            if (isHiddenAttributeAvailable) {
                newAlias.isHidden(Boolean.valueOf(true));
            }
            requestBuilder.addAlias(newAlias);
        }
        CreateIndexRequest request = (CreateIndexRequest)requestBuilder.request();
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, ActionListener.wrap(createIndexResponse -> listener.onResponse((Object)true), createIndexFailure -> {
            if (ExceptionsHelper.unwrapCause(createIndexFailure) instanceof ResourceAlreadyExistsException) {
                if (addAlias) {
                    MlIndexAndAlias.updateWriteAlias(client, alias, null, index, isHiddenAttributeAvailable, listener);
                } else {
                    listener.onResponse((Object)true);
                }
            } else {
                listener.onFailure(createIndexFailure);
            }
        }), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).create(arg_0, arg_1));
    }

    private static void updateWriteAlias(Client client, String alias, @Nullable String currentIndex, String newIndex, boolean isHiddenAttributeAvailable, ActionListener<Boolean> listener) {
        logger.info("About to move write alias [{}] from index [{}] to index [{}]", (Object)alias, (Object)currentIndex, (Object)newIndex);
        IndicesAliasesRequest.AliasActions addNewAliasAction = IndicesAliasesRequest.AliasActions.add().index(newIndex).alias(alias);
        if (isHiddenAttributeAvailable) {
            addNewAliasAction.isHidden(Boolean.valueOf(true));
        }
        IndicesAliasesRequestBuilder requestBuilder = client.admin().indices().prepareAliases().addAliasAction(addNewAliasAction);
        if (currentIndex != null) {
            requestBuilder.removeAlias(currentIndex, alias);
        }
        IndicesAliasesRequest request = (IndicesAliasesRequest)requestBuilder.request();
        ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", request, ActionListener.wrap(resp -> listener.onResponse((Object)resp.isAcknowledged()), arg_0 -> listener.onFailure(arg_0)), (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).aliases(arg_0, arg_1));
    }

    public static void installIndexTemplateIfRequired(ClusterState clusterState, Client client, Version versionComposableTemplateExpected, IndexTemplateConfig legacyTemplateConfig, IndexTemplateConfig templateConfig, TimeValue masterTimeout, ActionListener<Boolean> listener) {
        PutComposableIndexTemplateAction.Request request;
        String templateName;
        String legacyTemplateName = legacyTemplateConfig.getTemplateName();
        if (MlIndexAndAlias.hasIndexTemplate(clusterState, legacyTemplateName, templateName = templateConfig.getTemplateName(), versionComposableTemplateExpected)) {
            listener.onResponse((Object)true);
            return;
        }
        PutIndexTemplateRequest legacyRequest = (PutIndexTemplateRequest)new PutIndexTemplateRequest(legacyTemplateName).source(legacyTemplateConfig.loadBytes(), XContentType.JSON).masterNodeTimeout(masterTimeout);
        try {
            request = (PutComposableIndexTemplateAction.Request)new PutComposableIndexTemplateAction.Request(templateConfig.getTemplateName()).indexTemplate(ComposableIndexTemplate.parse((XContentParser)JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, templateConfig.loadBytes()))).masterNodeTimeout(masterTimeout);
        }
        catch (IOException e) {
            throw new ElasticsearchParseException("unable to parse composable template " + templateConfig.getTemplateName(), (Throwable)e, new Object[0]);
        }
        MlIndexAndAlias.installIndexTemplateIfRequired(clusterState, client, versionComposableTemplateExpected, legacyRequest, request, listener);
    }

    public static void installIndexTemplateIfRequired(ClusterState clusterState, Client client, Version versionComposableTemplateExpected, PutIndexTemplateRequest legacyTemplateRequest, PutComposableIndexTemplateAction.Request templateRequest, ActionListener<Boolean> listener) {
        if (MlIndexAndAlias.hasIndexTemplate(clusterState, legacyTemplateRequest.name(), templateRequest.name(), versionComposableTemplateExpected)) {
            listener.onResponse((Object)true);
            return;
        }
        if (versionComposableTemplateExpected != null && clusterState.nodes().getMinNodeVersion().onOrAfter(versionComposableTemplateExpected)) {
            ActionListener innerListener = ActionListener.wrap(response -> {
                if (!response.isAcknowledged()) {
                    logger.warn("error adding template [{}], request was not acknowledged", (Object)templateRequest.name());
                }
                listener.onResponse((Object)response.isAcknowledged());
            }, arg_0 -> listener.onFailure(arg_0));
            ClientHelper.executeAsyncWithOrigin(client, "ml", PutComposableIndexTemplateAction.INSTANCE, templateRequest, innerListener);
        } else {
            ActionListener innerListener = ActionListener.wrap(response -> {
                if (!response.isAcknowledged()) {
                    logger.warn("error adding legacy template [{}], request was not acknowledged", (Object)legacyTemplateRequest.name());
                }
                listener.onResponse((Object)response.isAcknowledged());
            }, arg_0 -> listener.onFailure(arg_0));
            ClientHelper.executeAsyncWithOrigin(client.threadPool().getThreadContext(), "ml", legacyTemplateRequest, innerListener, (arg_0, arg_1) -> ((IndicesAdminClient)client.admin().indices()).putTemplate(arg_0, arg_1));
        }
    }

    public static boolean hasIndexTemplate(ClusterState state, String legacyTemplateName, String templateName, Version versionComposableTemplateExpected) {
        if (versionComposableTemplateExpected != null && state.nodes().getMinNodeVersion().onOrAfter(versionComposableTemplateExpected)) {
            return state.getMetadata().templatesV2().containsKey(templateName);
        }
        return state.getMetadata().getTemplates().containsKey((Object)legacyTemplateName);
    }

    public static boolean hasIndex(ClusterState state, String index) {
        return state.getMetadata().getIndicesLookup().containsKey(index);
    }
}

