/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.StatusToXContentObject;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.AbstractGetResourcesResponse;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.action.util.QueryPage;
import org.elasticsearch.xpack.core.ml.calendars.Calendar;

public class GetCalendarsAction
extends ActionType<Response> {
    public static final GetCalendarsAction INSTANCE = new GetCalendarsAction();
    public static final String NAME = "cluster:monitor/xpack/ml/calendars/get";

    private GetCalendarsAction() {
        super(NAME, Response::new);
    }

    public static class Response
    extends AbstractGetResourcesResponse<Calendar>
    implements StatusToXContentObject {
        public Response(QueryPage<Calendar> calendars) {
            super(calendars);
        }

        public Response(StreamInput in) throws IOException {
            super(in);
        }

        @Override
        public RestStatus status() {
            return RestStatus.OK;
        }

        public QueryPage<Calendar> getCalendars() {
            return this.getResources();
        }

        @Override
        protected Writeable.Reader<Calendar> getReader() {
            return Calendar::new;
        }
    }

    public static class RequestBuilder
    extends ActionRequestBuilder<Request, Response> {
        public RequestBuilder(ElasticsearchClient client) {
            super(client, (ActionType)INSTANCE, (ActionRequest)new Request());
        }
    }

    public static class Request
    extends ActionRequest
    implements ToXContentObject {
        public static final String ALL = "_all";
        private static final ObjectParser<Request, Void> PARSER = new ObjectParser("cluster:monitor/xpack/ml/calendars/get", Request::new);
        private String calendarId;
        private PageParams pageParams;

        public static Request parseRequest(String calendarId, XContentParser parser) {
            Request request = (Request)((Object)PARSER.apply(parser, null));
            if (calendarId != null) {
                request.setCalendarId(calendarId);
            }
            return request;
        }

        public Request() {
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.calendarId = in.readOptionalString();
            this.pageParams = (PageParams)in.readOptionalWriteable(PageParams::new);
        }

        public void setCalendarId(String calendarId) {
            this.calendarId = calendarId;
        }

        public String getCalendarId() {
            return this.calendarId;
        }

        public PageParams getPageParams() {
            return this.pageParams;
        }

        public void setPageParams(PageParams pageParams) {
            this.pageParams = pageParams;
        }

        public ActionRequestValidationException validate() {
            ActionRequestValidationException validationException = null;
            if (this.calendarId != null && this.pageParams != null) {
                validationException = ValidateActions.addValidationError((String)("Params [" + PageParams.FROM.getPreferredName() + ", " + PageParams.SIZE.getPreferredName() + "] are incompatible with [" + Calendar.ID.getPreferredName() + "]."), validationException);
            }
            return validationException;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeOptionalString(this.calendarId);
            out.writeOptionalWriteable((Writeable)this.pageParams);
        }

        public int hashCode() {
            return Objects.hash(this.calendarId, this.pageParams);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.calendarId, other.calendarId) && Objects.equals(this.pageParams, other.pageParams);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.calendarId != null) {
                builder.field(Calendar.ID.getPreferredName(), this.calendarId);
            }
            if (this.pageParams != null) {
                builder.field(PageParams.PAGE.getPreferredName(), (ToXContent)this.pageParams);
            }
            builder.endObject();
            return builder;
        }

        static {
            PARSER.declareString(Request::setCalendarId, Calendar.ID);
            PARSER.declareObject(Request::setPageParams, PageParams.PARSER, PageParams.PAGE);
        }
    }
}

