/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ParseField;

public class DeleteLifecycleAction
extends ActionType<AcknowledgedResponse> {
    public static final DeleteLifecycleAction INSTANCE = new DeleteLifecycleAction();
    public static final String NAME = "cluster:admin/ilm/delete";

    protected DeleteLifecycleAction() {
        super(NAME, AcknowledgedResponse::readFrom);
    }

    public static class Request
    extends AcknowledgedRequest<Request> {
        public static final ParseField POLICY_FIELD = new ParseField("policy", new String[0]);
        private String policyName;

        public Request(String policyName) {
            this.policyName = policyName;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.policyName = in.readString();
        }

        public Request() {
        }

        public String getPolicyName() {
            return this.policyName;
        }

        public ActionRequestValidationException validate() {
            return null;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeString(this.policyName);
        }

        public int hashCode() {
            return Objects.hash(this.policyName);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (obj.getClass() != ((Object)((Object)this)).getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.policyName, other.policyName);
        }
    }
}

