/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Locale;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.Step;

public class SwapAliasesAndDeleteSourceIndexStep
extends AsyncActionStep {
    public static final String NAME = "swap-aliases";
    private static final Logger logger = LogManager.getLogger(SwapAliasesAndDeleteSourceIndexStep.class);
    private final String targetIndexPrefix;

    public SwapAliasesAndDeleteSourceIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, String targetIndexPrefix) {
        super(key, nextStepKey, client);
        this.targetIndexPrefix = targetIndexPrefix;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public String getTargetIndexPrefix() {
        return this.targetIndexPrefix;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentClusterState, ClusterStateObserver observer, ActionListener<Void> listener) {
        String originalIndex = indexMetadata.getIndex().getName();
        String targetIndexName = this.targetIndexPrefix + originalIndex;
        IndexMetadata targetIndexMetadata = currentClusterState.metadata().index(targetIndexName);
        if (targetIndexMetadata == null) {
            String policyName = indexMetadata.getSettings().get("index.lifecycle.name");
            String errorMessage = String.format(Locale.ROOT, "target index [%s] doesn't exist. stopping execution of lifecycle [%s] for index [%s]", targetIndexName, policyName, originalIndex);
            logger.debug(errorMessage);
            listener.onFailure((Exception)new IllegalStateException(errorMessage));
            return;
        }
        SwapAliasesAndDeleteSourceIndexStep.deleteSourceIndexAndTransferAliases(this.getClient(), indexMetadata, targetIndexName, listener);
    }

    static void deleteSourceIndexAndTransferAliases(Client client, IndexMetadata sourceIndex, String targetIndex, ActionListener<Void> listener) {
        String sourceIndexName = sourceIndex.getIndex().getName();
        IndicesAliasesRequest aliasesRequest = ((IndicesAliasesRequest)new IndicesAliasesRequest().masterNodeTimeout(TimeValue.MAX_VALUE)).addAliasAction(IndicesAliasesRequest.AliasActions.removeIndex().index(sourceIndexName)).addAliasAction(IndicesAliasesRequest.AliasActions.add().index(targetIndex).alias(sourceIndexName));
        sourceIndex.getAliases().values().forEach(aliasMetaDataToAdd -> aliasesRequest.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(targetIndex).alias(aliasMetaDataToAdd.alias()).indexRouting(aliasMetaDataToAdd.indexRouting()).searchRouting(aliasMetaDataToAdd.searchRouting()).filter(aliasMetaDataToAdd.filter() == null ? null : aliasMetaDataToAdd.filter().string()).writeIndex(null).isHidden(aliasMetaDataToAdd.isHidden())));
        client.admin().indices().aliases(aliasesRequest, ActionListener.wrap(response -> {
            if (!response.isAcknowledged()) {
                logger.warn("aliases swap from [{}] to [{}] response was not acknowledged", (Object)sourceIndexName, (Object)targetIndex);
            }
            listener.onResponse(null);
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public boolean indexSurvives() {
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.targetIndexPrefix);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SwapAliasesAndDeleteSourceIndexStep other = (SwapAliasesAndDeleteSourceIndexStep)obj;
        return super.equals(obj) && Objects.equals(this.targetIndexPrefix, other.targetIndexPrefix);
    }
}

