/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.forcemerge.ForceMergeRequest;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.ilm.AsyncActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleSettings;
import org.elasticsearch.xpack.core.ilm.Step;

public class ForceMergeStep
extends AsyncActionStep {
    public static final String NAME = "forcemerge";
    private static final Logger logger = LogManager.getLogger(ForceMergeStep.class);
    private final int maxNumSegments;

    public ForceMergeStep(Step.StepKey key, Step.StepKey nextStepKey, Client client, int maxNumSegments) {
        super(key, nextStepKey, client);
        this.maxNumSegments = maxNumSegments;
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    public int getMaxNumSegments() {
        return this.maxNumSegments;
    }

    @Override
    public void performAction(IndexMetadata indexMetadata, ClusterState currentState, ClusterStateObserver observer, ActionListener<Void> listener) {
        String indexName = indexMetadata.getIndex().getName();
        ForceMergeRequest request = new ForceMergeRequest(new String[]{indexName});
        request.maxNumSegments(this.maxNumSegments);
        this.getClient().admin().indices().forceMerge(request, ActionListener.wrap(response -> {
            if (response.getFailedShards() == 0) {
                listener.onResponse(null);
            } else {
                DefaultShardOperationFailedException[] failures = response.getShardFailures();
                String policyName = (String)LifecycleSettings.LIFECYCLE_NAME_SETTING.get(indexMetadata.getSettings());
                String errorMessage = String.format(Locale.ROOT, "index [%s] in policy [%s] encountered failures [%s] on step [%s]", indexName, policyName, failures == null ? "n/a" : Strings.collectionToDelimitedString((Iterable)Arrays.stream(failures).map(Strings::toString).collect(Collectors.toList()), (String)","), NAME);
                logger.warn(errorMessage);
                listener.onFailure((Exception)new ElasticsearchException(errorMessage, new Object[0]));
            }
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxNumSegments);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ForceMergeStep other = (ForceMergeStep)obj;
        return super.equals(obj) && Objects.equals(this.maxNumSegments, other.maxNumSegments);
    }
}

