/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.protocol.xpack.watcher;

import java.io.IOException;
import java.util.regex.Pattern;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.XContentType;

public final class PutWatchRequest
extends ActionRequest {
    private static final Pattern NO_WS_PATTERN = Pattern.compile("\\S+");
    private String id;
    private BytesReference source;
    private XContentType xContentType = XContentType.JSON;
    private boolean active = true;
    private long version = -3L;
    private long ifSeqNo = -2L;
    private long ifPrimaryTerm = 0L;

    public PutWatchRequest() {
    }

    public PutWatchRequest(StreamInput in) throws IOException {
        super(in);
        this.id = in.readString();
        this.source = in.readBytesReference();
        this.active = in.readBoolean();
        this.xContentType = (XContentType)in.readEnum(XContentType.class);
        this.version = in.readZLong();
        this.ifSeqNo = in.readZLong();
        this.ifPrimaryTerm = in.readVLong();
    }

    public PutWatchRequest(String id, BytesReference source, XContentType xContentType) {
        this.id = id;
        this.source = source;
        this.xContentType = xContentType;
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.id);
        out.writeBytesReference(this.source);
        out.writeBoolean(this.active);
        out.writeEnum((Enum)this.xContentType);
        out.writeZLong(this.version);
        out.writeZLong(this.ifSeqNo);
        out.writeVLong(this.ifPrimaryTerm);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public BytesReference getSource() {
        return this.source;
    }

    public void setSource(BytesReference source, XContentType xContentType) {
        this.source = source;
        this.xContentType = xContentType;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public XContentType xContentType() {
        return this.xContentType;
    }

    public long getVersion() {
        return this.version;
    }

    public void setVersion(long version) {
        this.version = version;
    }

    public PutWatchRequest setIfSeqNo(long seqNo) {
        if (seqNo < 0L && seqNo != -2L) {
            throw new IllegalArgumentException("sequence numbers must be non negative. got [" + seqNo + "].");
        }
        this.ifSeqNo = seqNo;
        return this;
    }

    public PutWatchRequest setIfPrimaryTerm(long term) {
        if (term < 0L) {
            throw new IllegalArgumentException("primary term must be non negative. got [" + term + "]");
        }
        this.ifPrimaryTerm = term;
        return this;
    }

    public long getIfSeqNo() {
        return this.ifSeqNo;
    }

    public long getIfPrimaryTerm() {
        return this.ifPrimaryTerm;
    }

    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (this.id == null) {
            validationException = ValidateActions.addValidationError((String)"watch id is missing", validationException);
        } else if (!PutWatchRequest.isValidId(this.id)) {
            validationException = ValidateActions.addValidationError((String)"watch id contains whitespace", (ActionRequestValidationException)validationException);
        }
        if (this.source == null) {
            validationException = ValidateActions.addValidationError((String)"watch source is missing", (ActionRequestValidationException)validationException);
        }
        if (this.xContentType == null || this.source != null && this.source.length() == 0) {
            validationException = ValidateActions.addValidationError((String)"request body is missing", (ActionRequestValidationException)validationException);
        }
        if (this.ifSeqNo != -2L && this.version != -3L) {
            validationException = ValidateActions.addValidationError((String)"compare and write operations can not use versioning", (ActionRequestValidationException)validationException);
        }
        if (this.ifPrimaryTerm == 0L && this.ifSeqNo != -2L) {
            validationException = ValidateActions.addValidationError((String)"ifSeqNo is set, but primary term is [0]", (ActionRequestValidationException)validationException);
        }
        if (this.ifPrimaryTerm != 0L && this.ifSeqNo == -2L) {
            validationException = ValidateActions.addValidationError((String)("ifSeqNo is unassigned, but primary term is [" + this.ifPrimaryTerm + "]"), (ActionRequestValidationException)validationException);
        }
        return validationException;
    }

    public static boolean isValidId(String id) {
        return !Strings.isEmpty((CharSequence)id) && NO_WS_PATTERN.matcher(id).matches();
    }
}

