/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.autoscaling.policy;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diffable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.autoscaling.policy.AutoscalingPolicy;

public class AutoscalingPolicyMetadata
extends AbstractDiffable<AutoscalingPolicyMetadata>
implements Diffable<AutoscalingPolicyMetadata>,
ToXContentObject {
    static final ParseField POLICY_FIELD = new ParseField("policy", new String[0]);
    private static final ConstructingObjectParser<AutoscalingPolicyMetadata, String> PARSER = new ConstructingObjectParser("autoscaling_policy_metadata", a -> {
        AutoscalingPolicy policy = (AutoscalingPolicy)((Object)((Object)a[0]));
        return new AutoscalingPolicyMetadata(policy);
    });
    private final AutoscalingPolicy policy;

    public static AutoscalingPolicyMetadata parse(XContentParser parser, String name) {
        return (AutoscalingPolicyMetadata)((Object)PARSER.apply(parser, (Object)name));
    }

    public AutoscalingPolicy policy() {
        return this.policy;
    }

    public AutoscalingPolicyMetadata(AutoscalingPolicy policy) {
        this.policy = policy;
    }

    public AutoscalingPolicyMetadata(StreamInput in) throws IOException {
        this.policy = new AutoscalingPolicy(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        this.policy.writeTo(out);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(POLICY_FIELD.getPreferredName(), (ToXContent)this.policy);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        AutoscalingPolicyMetadata that = (AutoscalingPolicyMetadata)((Object)o);
        return this.policy.equals((Object)that.policy);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.policy});
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.constructorArg(), AutoscalingPolicy::parse, POLICY_FIELD);
    }
}

