/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr.action.repositories;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.RemoteClusterAwareRequest;

public class GetCcrRestoreFileChunkRequest
extends ActionRequest
implements RemoteClusterAwareRequest {
    private final DiscoveryNode node;
    private final String sessionUUID;
    private final String fileName;
    private final int size;

    public ActionRequestValidationException validate() {
        return null;
    }

    public GetCcrRestoreFileChunkRequest(DiscoveryNode node, String sessionUUID, String fileName, int size) {
        this.node = node;
        this.sessionUUID = sessionUUID;
        this.fileName = fileName;
        this.size = size;
        assert (size > -1) : "The file chunk request size must be positive. Found: [" + size + "].";
    }

    GetCcrRestoreFileChunkRequest(StreamInput in) throws IOException {
        super(in);
        this.node = null;
        this.sessionUUID = in.readString();
        this.fileName = in.readString();
        this.size = in.readVInt();
    }

    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.sessionUUID);
        out.writeString(this.fileName);
        out.writeVInt(this.size);
    }

    String getSessionUUID() {
        return this.sessionUUID;
    }

    String getFileName() {
        return this.fileName;
    }

    int getSize() {
        return this.size;
    }

    public DiscoveryNode getPreferredTargetNode() {
        assert (this.node != null) : "Target node is null";
        return this.node;
    }
}

