/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ccr;

import java.io.IOException;
import java.util.Set;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.transport.RemoteClusterAware;
import org.elasticsearch.transport.RemoteConnectionStrategy;
import org.elasticsearch.xpack.ccr.action.repositories.DeleteInternalCcrRepositoryAction;
import org.elasticsearch.xpack.ccr.action.repositories.DeleteInternalCcrRepositoryRequest;
import org.elasticsearch.xpack.ccr.action.repositories.PutInternalCcrRepositoryAction;
import org.elasticsearch.xpack.ccr.action.repositories.PutInternalCcrRepositoryRequest;

class CcrRepositoryManager
extends AbstractLifecycleComponent {
    private final Client client;
    private final RemoteSettingsUpdateListener updateListener;

    CcrRepositoryManager(Settings settings, ClusterService clusterService, Client client) {
        this.client = client;
        this.updateListener = new RemoteSettingsUpdateListener(settings);
        this.updateListener.listenForUpdates(clusterService.getClusterSettings());
    }

    protected void doStart() {
        this.updateListener.init();
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
    }

    private void putRepository(String repositoryName) {
        PutInternalCcrRepositoryRequest request = new PutInternalCcrRepositoryRequest(repositoryName, "_ccr_");
        PlainActionFuture f = PlainActionFuture.newFuture();
        this.client.execute((ActionType)PutInternalCcrRepositoryAction.INSTANCE, (ActionRequest)request, (ActionListener)f);
        assert (f.isDone()) : "Should be completed as it is executed synchronously";
    }

    private void deleteRepository(String repositoryName) {
        DeleteInternalCcrRepositoryRequest request = new DeleteInternalCcrRepositoryRequest(repositoryName);
        PlainActionFuture f = PlainActionFuture.newFuture();
        this.client.execute((ActionType)DeleteInternalCcrRepositoryAction.INSTANCE, (ActionRequest)request, (ActionListener)f);
        assert (f.isDone()) : "Should be completed as it is executed synchronously";
    }

    private class RemoteSettingsUpdateListener
    extends RemoteClusterAware {
        private RemoteSettingsUpdateListener(Settings settings) {
            super(settings);
        }

        void init() {
            Set clusterAliases = RemoteSettingsUpdateListener.getEnabledRemoteClusters((Settings)this.settings);
            for (String clusterAlias : clusterAliases) {
                CcrRepositoryManager.this.putRepository("_ccr_" + clusterAlias);
            }
        }

        protected void updateRemoteCluster(String clusterAlias, Settings settings) {
            String repositoryName = "_ccr_" + clusterAlias;
            if (RemoteConnectionStrategy.isConnectionEnabled((String)clusterAlias, (Settings)settings)) {
                CcrRepositoryManager.this.putRepository(repositoryName);
            } else {
                CcrRepositoryManager.this.deleteRepository(repositoryName);
            }
        }
    }
}

