/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.searchablesnapshots.cache.common;

import java.util.Objects;
import org.elasticsearch.index.shard.ShardId;

public class CacheKey {
    private final String snapshotUUID;
    private final String snapshotIndexName;
    private final ShardId shardId;
    private final String fileName;

    public CacheKey(String snapshotUUID, String snapshotIndexName, ShardId shardId, String fileName) {
        this.snapshotUUID = Objects.requireNonNull(snapshotUUID);
        this.snapshotIndexName = Objects.requireNonNull(snapshotIndexName);
        this.shardId = Objects.requireNonNull(shardId);
        this.fileName = Objects.requireNonNull(fileName);
    }

    public String getSnapshotUUID() {
        return this.snapshotUUID;
    }

    public String getSnapshotIndexName() {
        return this.snapshotIndexName;
    }

    public ShardId getShardId() {
        return this.shardId;
    }

    public String getFileName() {
        return this.fileName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CacheKey cacheKey = (CacheKey)o;
        return Objects.equals(this.snapshotUUID, cacheKey.snapshotUUID) && Objects.equals(this.snapshotIndexName, cacheKey.snapshotIndexName) && Objects.equals(this.shardId, cacheKey.shardId) && Objects.equals(this.fileName, cacheKey.fileName);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotUUID, this.snapshotIndexName, this.shardId, this.fileName);
    }

    public String toString() {
        return "[snapshotUUID=" + this.snapshotUUID + ", snapshotIndexName=" + this.snapshotIndexName + ", shardId=" + this.shardId + ", fileName='" + this.fileName + "']";
    }
}

