/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.slm.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.SnapshotsInProgress;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleMetadata;
import org.elasticsearch.xpack.core.slm.SnapshotLifecyclePolicyItem;
import org.elasticsearch.xpack.core.slm.SnapshotLifecycleStats;
import org.elasticsearch.xpack.core.slm.action.GetSnapshotLifecycleAction;

public class TransportGetSnapshotLifecycleAction
extends TransportMasterNodeAction<GetSnapshotLifecycleAction.Request, GetSnapshotLifecycleAction.Response> {
    @Inject
    public TransportGetSnapshotLifecycleAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/slm/get", transportService, clusterService, threadPool, actionFilters, GetSnapshotLifecycleAction.Request::new, indexNameExpressionResolver, GetSnapshotLifecycleAction.Response::new, "same");
    }

    protected void masterOperation(GetSnapshotLifecycleAction.Request request, ClusterState state, ActionListener<GetSnapshotLifecycleAction.Response> listener) {
        SnapshotLifecycleMetadata snapMeta = (SnapshotLifecycleMetadata)state.metadata().custom("snapshot_lifecycle");
        if (snapMeta == null) {
            if (request.getLifecycleIds().length == 0) {
                listener.onResponse((Object)new GetSnapshotLifecycleAction.Response(Collections.emptyList()));
            } else {
                listener.onFailure((Exception)new ResourceNotFoundException("snapshot lifecycle policy or policies {} not found, no policies are configured", new Object[]{Arrays.toString(request.getLifecycleIds())}));
            }
        } else {
            Map<String, SnapshotLifecyclePolicyItem.SnapshotInProgress> inProgress;
            SnapshotsInProgress sip = (SnapshotsInProgress)state.custom("snapshots");
            if (sip == null) {
                inProgress = Collections.emptyMap();
            } else {
                inProgress = new HashMap();
                for (List entriesForRepo : sip.entriesByRepo()) {
                    for (SnapshotsInProgress.Entry entry : entriesForRepo) {
                        Map meta2 = entry.userMetadata();
                        if (meta2 == null || meta2.get("policy") == null || !(meta2.get("policy") instanceof String)) continue;
                        String policyId = (String)meta2.get("policy");
                        inProgress.put(policyId, SnapshotLifecyclePolicyItem.SnapshotInProgress.fromEntry((SnapshotsInProgress.Entry)entry));
                    }
                }
            }
            HashSet<String> ids = new HashSet<String>(Arrays.asList(request.getLifecycleIds()));
            SnapshotLifecycleStats slmStats = snapMeta.getStats();
            List lifecycles = snapMeta.getSnapshotConfigurations().values().stream().filter(meta -> {
                if (ids.isEmpty()) {
                    return true;
                }
                return ids.contains(meta.getPolicy().getId());
            }).map(policyMeta -> new SnapshotLifecyclePolicyItem(policyMeta, (SnapshotLifecyclePolicyItem.SnapshotInProgress)inProgress.get(policyMeta.getPolicy().getId()), (SnapshotLifecycleStats.SnapshotPolicyStats)slmStats.getMetrics().get(policyMeta.getPolicy().getId()))).collect(Collectors.toList());
            if (lifecycles.size() == 0) {
                if (request.getLifecycleIds().length == 0) {
                    listener.onResponse((Object)new GetSnapshotLifecycleAction.Response(Collections.emptyList()));
                } else {
                    listener.onFailure((Exception)new ResourceNotFoundException("snapshot lifecycle policy or policies {} not found", new Object[]{Arrays.toString(request.getLifecycleIds())}));
                }
            } else {
                listener.onResponse((Object)new GetSnapshotLifecycleAction.Response(lifecycles));
            }
        }
    }

    protected ClusterBlockException checkBlock(GetSnapshotLifecycleAction.Request request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

