/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.plugin;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.sql.action.BasicFormatter;
import org.elasticsearch.xpack.sql.session.Cursor;
import org.elasticsearch.xpack.sql.session.SqlConfiguration;

public class TextFormatterCursor
implements Cursor {
    public static final String NAME = "f";
    private final Cursor delegate;
    private final BasicFormatter formatter;

    TextFormatterCursor(Cursor delegate, BasicFormatter formatter) {
        this.delegate = delegate;
        this.formatter = formatter;
    }

    public TextFormatterCursor(StreamInput in) throws IOException {
        this.delegate = (Cursor)in.readNamedWriteable(Cursor.class);
        this.formatter = new BasicFormatter(in);
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable((NamedWriteable)this.delegate);
        this.formatter.writeTo(out);
    }

    public BasicFormatter getFormatter() {
        return this.formatter;
    }

    @Override
    public void nextPage(SqlConfiguration cfg, Client client, NamedWriteableRegistry registry, ActionListener<Cursor.Page> listener) {
        this.delegate.nextPage(cfg, client, registry, (ActionListener<Cursor.Page>)ActionListener.wrap(p -> {
            Cursor next = p.next();
            listener.onResponse((Object)(next == Cursor.EMPTY ? p : new Cursor.Page(p.rowSet(), new TextFormatterCursor(next, this.formatter))));
        }, arg_0 -> listener.onFailure(arg_0)));
    }

    @Override
    public void clear(Client client, ActionListener<Boolean> listener) {
        this.delegate.clear(client, listener);
    }

    public String getWriteableName() {
        return NAME;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TextFormatterCursor that = (TextFormatterCursor)o;
        return Objects.equals(this.delegate, that.delegate) && Objects.equals(this.formatter, that.formatter);
    }

    public int hashCode() {
        return Objects.hash(this.delegate, this.formatter);
    }
}

