/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.sql.execution.search;

import java.util.BitSet;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.search.aggregations.bucket.MultiBucketsAggregation;
import org.elasticsearch.search.aggregations.bucket.composite.CompositeAggregation;
import org.elasticsearch.xpack.ql.execution.search.extractor.BucketExtractor;
import org.elasticsearch.xpack.sql.execution.search.CompositeAggCursor;
import org.elasticsearch.xpack.sql.execution.search.ResultRowSet;

class CompositeAggRowSet
extends ResultRowSet<BucketExtractor> {
    final List<? extends CompositeAggregation.Bucket> buckets;
    Map<String, Object> afterKey;
    int remainingData;
    int size;
    int row = 0;

    CompositeAggRowSet(List<BucketExtractor> exts, BitSet mask, SearchResponse response, int limit) {
        super(exts, mask);
        CompositeAggregation composite = CompositeAggCursor.getComposite(response);
        if (composite != null) {
            this.buckets = composite.getBuckets();
            this.afterKey = composite.afterKey();
        } else {
            this.buckets = Collections.emptyList();
            this.afterKey = null;
        }
        this.size = limit == -1 ? this.buckets.size() : Math.min(this.buckets.size(), limit);
        this.remainingData = CompositeAggRowSet.remainingData(this.afterKey != null, this.size, limit);
    }

    static int remainingData(boolean hasNextPage, int size, int limit) {
        if (!hasNextPage) {
            return 0;
        }
        int remainingLimit = limit == -1 ? limit : (limit - size >= 0 ? limit - size : 0);
        return size == 0 ? size : remainingLimit;
    }

    @Override
    protected Object extractValue(BucketExtractor e) {
        return e.extract((MultiBucketsAggregation.Bucket)this.buckets.get(this.row));
    }

    @Override
    protected boolean doHasCurrent() {
        return this.row < this.size;
    }

    @Override
    protected boolean doNext() {
        if (this.row < this.size - 1) {
            ++this.row;
            return true;
        }
        return false;
    }

    @Override
    protected void doReset() {
        this.row = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    int remainingData() {
        return this.remainingData;
    }

    Map<String, Object> afterKey() {
        return this.afterKey;
    }
}

