/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.sp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.cache.CacheBuilder;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.core.TimeValue;

public final class ServiceProviderCacheSettings {
    private static final int CACHE_SIZE_DEFAULT = 1000;
    private static final TimeValue CACHE_TTL_DEFAULT = TimeValue.timeValueMinutes((long)60L);
    public static final Setting<Integer> CACHE_SIZE = Setting.intSetting((String)"xpack.idp.sp.cache.size", (int)1000, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<TimeValue> CACHE_TTL = Setting.timeSetting((String)"xpack.idp.sp.cache.ttl", (TimeValue)CACHE_TTL_DEFAULT, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});

    static <K, V> Cache<K, V> buildCache(Settings settings) {
        return CacheBuilder.builder().setMaximumWeight((long)((Integer)CACHE_SIZE.get(settings)).intValue()).setExpireAfterAccess((TimeValue)CACHE_TTL.get(settings)).build();
    }

    public static List<Setting<?>> getSettings() {
        return Collections.unmodifiableList(Arrays.asList(CACHE_SIZE, CACHE_TTL));
    }
}

