/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.rest.results;

import java.io.IOException;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetBucketsAction;
import org.elasticsearch.xpack.core.ml.job.config.Job;
import org.elasticsearch.xpack.core.ml.job.results.Result;

public class RestGetBucketsAction
extends BaseRestHandler {
    public List<RestHandler.Route> routes() {
        return org.elasticsearch.core.List.of((Object[])new RestHandler.Route[]{RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)("/_ml/anomaly_detectors/{" + Job.ID + "}/results/buckets/{" + Result.TIMESTAMP + "}")).replaces(RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID + "}/results/buckets/{" + Result.TIMESTAMP + "}", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)("/_ml/anomaly_detectors/{" + Job.ID + "}/results/buckets/{" + Result.TIMESTAMP + "}")).replaces(RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID + "}/results/buckets/{" + Result.TIMESTAMP + "}", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)("/_ml/anomaly_detectors/{" + Job.ID + "}/results/buckets")).replaces(RestRequest.Method.GET, "/_xpack/ml/anomaly_detectors/{" + Job.ID + "}/results/buckets", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.POST, (String)("/_ml/anomaly_detectors/{" + Job.ID + "}/results/buckets")).replaces(RestRequest.Method.POST, "/_xpack/ml/anomaly_detectors/{" + Job.ID + "}/results/buckets", RestApiVersion.V_7).build()});
    }

    public String getName() {
        return "ml_get_buckets_action";
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest restRequest, NodeClient client) throws IOException {
        GetBucketsAction.Request request;
        String jobId = restRequest.param(Job.ID.getPreferredName());
        String timestamp = restRequest.param(GetBucketsAction.Request.TIMESTAMP.getPreferredName());
        if (restRequest.hasContentOrSourceParam()) {
            XContentParser parser = restRequest.contentOrSourceParamParser();
            request = GetBucketsAction.Request.parseRequest((String)jobId, (XContentParser)parser);
            if (!Strings.isNullOrEmpty((String)timestamp)) {
                request.setTimestamp(timestamp);
            }
        } else {
            request = new GetBucketsAction.Request(jobId);
            if (!Strings.isNullOrEmpty((String)timestamp)) {
                request.setTimestamp(timestamp);
            }
            if (restRequest.hasParam(PageParams.FROM.getPreferredName()) || restRequest.hasParam(PageParams.SIZE.getPreferredName())) {
                request.setPageParams(new PageParams(restRequest.paramAsInt(PageParams.FROM.getPreferredName(), 0), restRequest.paramAsInt(PageParams.SIZE.getPreferredName(), 100)));
            }
            if (restRequest.hasParam(GetBucketsAction.Request.START.getPreferredName())) {
                request.setStart(restRequest.param(GetBucketsAction.Request.START.getPreferredName()));
            }
            if (restRequest.hasParam(GetBucketsAction.Request.END.getPreferredName())) {
                request.setEnd(restRequest.param(GetBucketsAction.Request.END.getPreferredName()));
            }
            if (restRequest.hasParam(GetBucketsAction.Request.ANOMALY_SCORE.getPreferredName())) {
                request.setAnomalyScore(Double.parseDouble(restRequest.param(GetBucketsAction.Request.ANOMALY_SCORE.getPreferredName(), "0.0")));
            }
            if (restRequest.hasParam(GetBucketsAction.Request.SORT.getPreferredName())) {
                request.setSort(restRequest.param(GetBucketsAction.Request.SORT.getPreferredName()));
            }
            request.setDescending(restRequest.paramAsBoolean(GetBucketsAction.Request.DESCENDING.getPreferredName(), request.isDescending()));
            request.setExpand(restRequest.paramAsBoolean(GetBucketsAction.Request.EXPAND.getPreferredName(), false));
            request.setExcludeInterim(restRequest.paramAsBoolean(GetBucketsAction.Request.EXCLUDE_INTERIM.getPreferredName(), false));
        }
        return channel -> client.execute((ActionType)GetBucketsAction.INSTANCE, (ActionRequest)request, (ActionListener)new RestToXContentListener(channel));
    }
}

