/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ml.dataframe.traintestsplit;

import java.util.List;
import java.util.Random;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.ml.dataframe.traintestsplit.TrainTestSplitter;

abstract class AbstractReservoirTrainTestSplitter
implements TrainTestSplitter {
    protected final int dependentVariableIndex;
    private final double samplingRatio;
    private final Random random;

    AbstractReservoirTrainTestSplitter(List<String> fieldNames, String dependentVariable, double trainingPercent, long randomizeSeed) {
        assert (trainingPercent >= 1.0 && trainingPercent <= 100.0);
        this.dependentVariableIndex = AbstractReservoirTrainTestSplitter.findDependentVariableIndex(fieldNames, dependentVariable);
        this.samplingRatio = trainingPercent / 100.0;
        this.random = new Random(randomizeSeed);
    }

    private static int findDependentVariableIndex(List<String> fieldNames, String dependentVariable) {
        int dependentVariableIndex = fieldNames.indexOf(dependentVariable);
        if (dependentVariableIndex < 0) {
            throw ExceptionsHelper.serverError((String)("Could not find dependent variable [" + dependentVariable + "] in fields " + fieldNames));
        }
        return dependentVariableIndex;
    }

    @Override
    public boolean isTraining(String[] row) {
        if (!this.canBeUsedForTraining(row)) {
            return false;
        }
        SampleInfo sample = this.getSampleInfo(row);
        long targetSampleCount = (long)Math.max(1.0, this.samplingRatio * (double)sample.classCount);
        double p = (double)(targetSampleCount - sample.training) / (double)(sample.classCount - sample.observed);
        boolean isTraining = this.random.nextDouble() <= p;
        sample.observed++;
        if (isTraining) {
            sample.training++;
            return true;
        }
        return false;
    }

    private boolean canBeUsedForTraining(String[] row) {
        return row[this.dependentVariableIndex] != "\u0000";
    }

    protected abstract SampleInfo getSampleInfo(String[] var1);

    static class SampleInfo {
        private final long classCount;
        private long training;
        private long observed;

        SampleInfo(long classCount) {
            this.classCount = classCount;
        }
    }
}

