/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.CheckedBiFunction;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.TriFunction;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.mapper.AbstractGeometryFieldMapper;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.MappingParserContext;
import org.elasticsearch.xcontent.XContentParser;

public abstract class AbstractPointGeometryFieldMapper<T>
extends AbstractGeometryFieldMapper<T> {
    protected final T nullValue;

    public static <T> FieldMapper.Parameter<T> nullValueParam(Function<FieldMapper, T> initializer, TriFunction<String, MappingParserContext, Object, T> parser, Supplier<T> def) {
        return new FieldMapper.Parameter<T>("null_value", false, def, parser, initializer);
    }

    protected AbstractPointGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> ignoreZValue, T nullValue, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<T> parser) {
        super(simpleName, mappedFieldType, ignoreMalformed, ignoreZValue, multiFields, copyTo, parser);
        this.nullValue = nullValue;
    }

    protected AbstractPointGeometryFieldMapper(String simpleName, MappedFieldType mappedFieldType, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo, AbstractGeometryFieldMapper.Parser<T> parser, String onScriptError) {
        super(simpleName, mappedFieldType, multiFields, copyTo, parser, onScriptError);
        this.nullValue = null;
    }

    public T getNullValue() {
        return this.nullValue;
    }

    protected static abstract class PointParser<T>
    extends AbstractGeometryFieldMapper.Parser<T> {
        protected final String field;
        private final Supplier<T> pointSupplier;
        private final CheckedBiFunction<XContentParser, T, T, IOException> objectParser;
        private final T nullValue;
        private final boolean ignoreZValue;
        protected final boolean ignoreMalformed;

        protected PointParser(String field, Supplier<T> pointSupplier, CheckedBiFunction<XContentParser, T, T, IOException> objectParser, T nullValue, boolean ignoreZValue, boolean ignoreMalformed) {
            this.field = field;
            this.pointSupplier = pointSupplier;
            this.objectParser = objectParser;
            this.nullValue = nullValue == null ? null : this.validate(nullValue);
            this.ignoreZValue = ignoreZValue;
            this.ignoreMalformed = ignoreMalformed;
        }

        protected abstract T validate(T var1);

        protected abstract void reset(T var1, double var2, double var4);

        @Override
        public void parse(XContentParser parser, CheckedConsumer<T, IOException> consumer, Consumer<Exception> onMalformed) throws IOException {
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                XContentParser.Token token = parser.nextToken();
                T point = this.pointSupplier.get();
                if (token == XContentParser.Token.VALUE_NUMBER) {
                    double x = parser.doubleValue();
                    parser.nextToken();
                    double y = parser.doubleValue();
                    token = parser.nextToken();
                    if (token == XContentParser.Token.VALUE_NUMBER) {
                        if (!this.ignoreZValue) {
                            throw new ElasticsearchParseException("Exception parsing coordinates: found Z value [{}] but [ignore_z_value] parameter is [{}]", parser.doubleValue(), this.ignoreZValue);
                        }
                    } else if (token != XContentParser.Token.END_ARRAY) {
                        throw new ElasticsearchParseException("field type does not accept > 3 dimensions", new Object[0]);
                    }
                    this.reset(point, x, y);
                    consumer.accept(this.validate(point));
                } else {
                    while (token != XContentParser.Token.END_ARRAY) {
                        this.parseAndConsumeFromObject(parser, point, consumer, onMalformed);
                        point = this.pointSupplier.get();
                        token = parser.nextToken();
                    }
                }
            } else if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                if (this.nullValue != null) {
                    consumer.accept(this.nullValue);
                }
            } else {
                this.parseAndConsumeFromObject(parser, this.pointSupplier.get(), consumer, onMalformed);
            }
        }

        private void parseAndConsumeFromObject(XContentParser parser, T point, CheckedConsumer<T, IOException> consumer, Consumer<Exception> onMalformed) {
            try {
                point = this.objectParser.apply(parser, (XContentParser)point);
                consumer.accept(this.validate(point));
            }
            catch (Exception e) {
                onMalformed.accept(e);
            }
        }
    }
}

