/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.watcher.rest.action;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.logging.DeprecationCategory;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.core.RestApiVersion;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestActions;
import org.elasticsearch.xpack.core.watcher.client.WatcherClient;
import org.elasticsearch.xpack.core.watcher.transport.actions.stats.WatcherStatsRequest;
import org.elasticsearch.xpack.watcher.rest.WatcherRestHandler;

public class RestWatcherStatsAction
extends WatcherRestHandler {
    private static final Logger logger = LogManager.getLogger(RestWatcherStatsAction.class);
    private static final DeprecationLogger deprecationLogger = DeprecationLogger.getLogger(RestWatcherStatsAction.class);
    private static final Set<String> RESPONSE_PARAMS = Collections.singleton("emit_stacktraces");

    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_watcher/stats").replaces(RestRequest.Method.GET, URI_BASE + "/watcher/stats", RestApiVersion.V_7).build(), RestHandler.Route.builder((RestRequest.Method)RestRequest.Method.GET, (String)"/_watcher/stats/{metric}").replaces(RestRequest.Method.GET, URI_BASE + "/watcher/stats/{metric}", RestApiVersion.V_7).build()));
    }

    public String getName() {
        return "watcher_stats";
    }

    @Override
    protected BaseRestHandler.RestChannelConsumer doPrepareRequest(RestRequest restRequest, WatcherClient client) {
        Set metrics = Strings.tokenizeByCommaToSet((String)restRequest.param("metric", ""));
        WatcherStatsRequest request = new WatcherStatsRequest();
        if (metrics.contains("_all")) {
            request.includeCurrentWatches(true);
            request.includeQueuedWatches(true);
        } else {
            request.includeCurrentWatches(metrics.contains("current_watches"));
            request.includeQueuedWatches(metrics.contains("queued_watches") || metrics.contains("pending_watches"));
        }
        if (metrics.contains("pending_watches")) {
            deprecationLogger.warn(DeprecationCategory.API, "pending_watches", "The pending_watches parameter is deprecated, use queued_watches instead", new Object[0]);
        }
        return channel -> client.watcherStats(request, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    protected Set<String> responseParams() {
        return RESPONSE_PARAMS;
    }
}

